CONTAINER VPgisetup
{
	NAME VPgisetup;
	INCLUDE VPbase;
	
	GROUP GI_GROUP_GENERAL
	{
		DEFAULT 1;
		COLUMNS 2;

		// **************************************************************************************************
		// --- Animation ---
		LONG GI_SETUP_DATA_ANIMATION_METHOD 
		{ 
			PARENTCOLLAPSE;
			ANIM OFF;
			CYCLE 
			{
				GI_SETUP_MASTER_MODE_IC_IC;
				GI_SETUP_MASTER_MODE_IC_IC_CAMERA;
				0;
				GI_SETUP_MASTER_MODE_QMC;
				0;
				GI_SETUP_MASTER_MODE_IC_QMC;
				GI_SETUP_MASTER_MODE_IC_QMC_CAMERA;
				GI_SETUP_MASTER_MODE_IC_QMC_FULL;
				GI_SETUP_MASTER_MODE_IC_QMC_FULL_NET;
				0;
				GI_SETUP_MASTER_MODE_SKY;
			} 
		}

		STATICTEXT { }

		LONG GI_SETUP_DATA_ANIMATION_DETECTION_COMBO
		{
			PARENTCOLLAPSE GI_SETUP_DATA_ANIMATION_METHOD;
			ANIM OFF;
			CYCLE 
			{ 
				GI_SETUP_ANIMATION_DETECTION_LOW;	
				GI_SETUP_ANIMATION_DETECTION_NORMAL;
				GI_SETUP_ANIMATION_DETECTION_HIGH;
				GI_SETUP_ANIMATION_DETECTION_CUSTOM;
			}
		}

		LONG GI_SETUP_DATA_ANIMATION_DETECTION_VALUE
		{ 
			PARENTCOLLAPSE GI_SETUP_DATA_ANIMATION_METHOD;
			ANIM OFF;
			MIN 16; 
			MAX 128;
			STEP 8; 
		}

		LONG GI_SETUP_DATA_ANIMATION_INTERPOLATION_COMBO
		{
			PARENTCOLLAPSE GI_SETUP_DATA_ANIMATION_METHOD;
			ANIM OFF;
			CYCLE 
			{ 
				GI_SETUP_ANIMATION_INTERPOLATION_LOW;
				GI_SETUP_ANIMATION_INTERPOLATION_NORMAL;
				GI_SETUP_ANIMATION_INTERPOLATION_HIGH;
				GI_SETUP_ANIMATION_INTERPOLATION_CUSTOM;
			}
		}

		REAL GI_SETUP_DATA_ANIMATION_INTERPOLATION_VALUE
		{ 
			PARENTCOLLAPSE GI_SETUP_DATA_ANIMATION_METHOD;
			ANIM OFF;
			MIN 10.0; 
			MAX 100.0; 
			UNIT PERCENT;
		}

		BOOL GI_SETUP_DATA_ANIMATION_QMC_ENABLE
		{
			PARENTCOLLAPSE GI_SETUP_DATA_ANIMATION_METHOD;
			ANIM OFF;
		}

		REAL GI_SETUP_DATA_ANIMATION_QMC_VALUE
		{
			PARENTCOLLAPSE GI_SETUP_DATA_ANIMATION_METHOD;
			ANIM OFF;
			MIN 0.25; 
			MAX 10.0; 
			STEP 0.25; 
		}


		// **************************************************************************************************
		// --- Depth and Methods ---
		LONG GI_SETUP_DATA_DIFFUSE_DEPTH
		{
			ANIM OFF;
			MIN 1; 
			MAX 8; 
		}
		
		STATICTEXT {}

		REAL GI_SETUP_DATA_PRIMARY_INTENSITY
		{ 
			ANIM OFF;
			MIN 0.1; 
			MAX 10000.0; 
			UNIT PERCENT;
		}

		STATICTEXT {}

		REAL GI_SETUP_DATA_SECONDARY_INTENSITY
		{ 
			ANIM OFF;
			MIN 0.1; 
			MAX 10000.0; 
			UNIT PERCENT;
		}

		STATICTEXT {}

		// **************************************************************************************************
		// --- Gamma Correction
		//LONG GI_SETUP_DATA_GAMMA_METHOD
		//{ 
		//	ANIM OFF;
		//	CYCLE 
		//	{ 
		//		GI_SETUP_GAMMA_NONE;
		//		GI_SETUP_GAMMA_FINAL;
		//		GI_SETUP_GAMMA_RECORD;
		//	} 
		//}
		//STATICTEXT {}

		REAL GI_SETUP_DATA_GAMMA_VALUE
		{ 
			ANIM OFF;
			MIN 0.1; 
			MAX 10.0; 
			STEP 0.1; 
		}
	}

	// **************************************************************************************************
	// --- Sky Sampler ---
	GROUP GI_GROUP_SKY
	{
		LONG GI_SETUP_DATA_SKY_SAMPLES
		{
			ANIM OFF;
			MIN 4; 
			MAX 4096; 
		}
	}

	// **************************************************************************************************
	// --- QMC ---
	GROUP GI_GROUP_QMC			
	{
		COLUMNS 2;

		LONG GI_SETUP_DATA_QMC_COUNT
		{
			ANIM OFF;
			MIN 1; 
			MAX 16384; 
			STEP 1; 
		}

		STATICTEXT { SCALE_H; }

		LONG GI_SETUP_DATA_QMC_OVERSAMPLING_METHOD
		{
			PARENTCOLLAPSE;
			ANIM OFF;
			CYCLE
			{
				GI_SETUP_XSAMPLING_CUSTOM;
				GI_SETUP_XSAMPLING_NONE;
				GI_SETUP_XSAMPLING_MINIMAL;
				GI_SETUP_XSAMPLING_WEAK;
				GI_SETUP_XSAMPLING_MEDIUM;
				GI_SETUP_XSAMPLING_HEAVY;
				GI_SETUP_XSAMPLING_VERY_HEAVY;
			}
		}

		STATICTEXT { }
		
		LONG GI_SETUP_DATA_QMC_OVERSAMPLING_RATIO
		{
			PARENTCOLLAPSE GI_SETUP_DATA_QMC_OVERSAMPLING_METHOD;
			ANIM OFF;
			MIN 1; 
			MAX 4096; 
		}

		STATICTEXT { PARENTCOLLAPSE GI_SETUP_DATA_QMC_OVERSAMPLING_METHOD; }
	}


	// **************************************************************************************************
	// --- Irradiance Cache ---
	GROUP GI_GROUP_IRRADIANCE				
	{
		COLUMNS 2;
		
		// **************************************************************************************************
		// --- Sampling Quality Section
		LONG GI_SETUP_DATA_IR_COUNT_METHOD
		{ 
			PARENTCOLLAPSE;
			ANIM OFF;
			CYCLE 
			{
				GI_SETUP_COUNT_USER;			
				GI_SETUP_COUNT_CUSTOM;
				GI_SETUP_COUNT_LOW;
				GI_SETUP_COUNT_MEDIUM;
				GI_SETUP_COUNT_HIGH;
			}
		}

		STATICTEXT { SCALE_H; } 

		REAL GI_SETUP_DATA_IR_COUNT_THRESHOLD
		{
			ANIM OFF;
			MIN 0.0; 
			MAX 200.0; 
			UNIT PERCENT;
			PARENTCOLLAPSE GI_SETUP_DATA_IR_COUNT_METHOD;
		}

		STATICTEXT { SCALE_H; PARENTCOLLAPSE GI_SETUP_DATA_IR_COUNT_METHOD;} 

		LONG GI_SETUP_DATA_IR_COUNT_USER
		{
			ANIM OFF;
			MIN 1; 
			MAX 16384; 
			PARENTCOLLAPSE GI_SETUP_DATA_IR_COUNT_METHOD;
		}

		STATICTEXT { SCALE_H; PARENTCOLLAPSE GI_SETUP_DATA_IR_COUNT_METHOD;} 

		// **************************************************************************************************
		// --- Cache Density Section ---
		LONG GI_SETUP_DATA_IR_DENSITY_QUALITY
		{ 
			PARENTCOLLAPSE;
			ANIM OFF;
			CYCLE 
			{ 
				GI_SETUP_QUALITY_CUSTOM;
				GI_SETUP_QUALITY_PREVIEW;
				GI_SETUP_QUALITY_LOW;
				GI_SETUP_QUALITY_MEDIUM;
				GI_SETUP_QUALITY_HIGH;
				GI_SETUP_QUALITY_HIGH_DETAILS;	
				GI_SETUP_QUALITY_DLOW;
				GI_SETUP_QUALITY_DMEDIUM;
				GI_SETUP_QUALITY_DHIGH;	
			} 
		}

		STATICTEXT { SCALE_H; } 

		LONG GI_SETUP_DATA_IR_DENSITY_RATE_MIN
		{
			ANIM OFF;
			MIN -8; 
			MAX 4; 
			PARENTCOLLAPSE GI_SETUP_DATA_IR_DENSITY_QUALITY;
		}
		
		STATICTEXT { PARENTCOLLAPSE GI_SETUP_DATA_IR_DENSITY_QUALITY; }

		LONG GI_SETUP_DATA_IR_DENSITY_RATE_MAX
		{

			ANIM OFF;
			MIN -8; 
			MAX 4; 
			PARENTCOLLAPSE GI_SETUP_DATA_IR_DENSITY_QUALITY;
		}

		STATICTEXT { PARENTCOLLAPSE GI_SETUP_DATA_IR_DENSITY_QUALITY; }

		REAL GI_SETUP_DATA_IR_DENSITY_RADIUS_MAX
		{ 
			ANIM OFF;
			MIN 0.0; 
			MAX 100.0; 
			UNIT PERCENT;
			PARENTCOLLAPSE GI_SETUP_DATA_IR_DENSITY_QUALITY;
		}

		STATICTEXT { PARENTCOLLAPSE GI_SETUP_DATA_IR_DENSITY_QUALITY; } 

		REAL GI_SETUP_DATA_IR_DENSITY_RADIUS_MIN
		{ 
			ANIM OFF;
			MIN 0.0; 
			MAX 100.0; 
			UNIT PERCENT;
			PARENTCOLLAPSE GI_SETUP_DATA_IR_DENSITY_QUALITY;
		}


		STATICTEXT { PARENTCOLLAPSE GI_SETUP_DATA_IR_DENSITY_QUALITY; } 

		REAL GI_SETUP_DATA_IR_DENSITY_CONTROL
		{ 
			ANIM OFF;
			MIN 0.0; 
			MAX 100.0; 
			UNIT PERCENT;
			PARENTCOLLAPSE GI_SETUP_DATA_IR_DENSITY_QUALITY; 
		}

		STATICTEXT { PARENTCOLLAPSE GI_SETUP_DATA_IR_DENSITY_QUALITY; }

		BOOL GI_SETUP_DATA_IR_DENSITY_PROXIMITY
		{
			ANIM OFF;
			PARENTCOLLAPSE GI_SETUP_DATA_IR_DENSITY_QUALITY; 
		}

		STATICTEXT { PARENTCOLLAPSE GI_SETUP_DATA_IR_DENSITY_QUALITY; }

		// **************************************************************************************************
		// --- Interpolation and Smoothing Properties ---
		LONG GI_SETUP_DATA_IR_INTERPOLATION_METHOD
		{ 
			ANIM OFF;
			CYCLE 
			{ 
				GI_SETUP_INTERPOLATION_LEAST_SQUARES;
				GI_SETUP_INTERPOLATION_WEIGHTED;
				GI_SETUP_INTERPOLATION_D_TRIANGULATION;
				GI_SETUP_INTERPOLATION_NONE;
			}
		}

		STATICTEXT {}

		LONG GI_SETUP_DATA_IR_INTERPOLATION_SMOOTHING
		{ 
			PARENTCOLLAPSE; 
			ANIM OFF;
			CYCLE 
			{ 
				GI_SETUP_SMOOTHING_CUSTOM;			
				GI_SETUP_SMOOTHING_MINIMAL;
				GI_SETUP_SMOOTHING_WEAK;
				GI_SETUP_SMOOTHING_MEDIUM;
				GI_SETUP_SMOOTHING_HEAVY;
				GI_SETUP_SMOOTHING_VERY_HEAVY;
			}
		}
		
		STATICTEXT { }

		LONG GI_SETUP_DATA_IR_INTERPOLATION_MAX_SAMPLES
		{
			PARENTCOLLAPSE GI_SETUP_DATA_IR_INTERPOLATION_SMOOTHING; 
			ANIM OFF;
			MIN 8; 
			MAX 256; 
		}

		STATICTEXT { PARENTCOLLAPSE GI_SETUP_DATA_IR_INTERPOLATION_SMOOTHING; }
	
		REAL GI_SETUP_DATA_IR_INTERPOLATION_MAX_RADIUS_SCALE
		{ 
			PARENTCOLLAPSE GI_SETUP_DATA_IR_INTERPOLATION_SMOOTHING; 
			ANIM OFF;
			MIN 1.6; 
			MAX 8.0; 
			STEP 0.1; 
		}

		STATICTEXT { PARENTCOLLAPSE GI_SETUP_DATA_IR_INTERPOLATION_SMOOTHING; }
		
		BOOL GI_SETUP_DATA_IR_INTERPOLATION_DT_SHOW_EDGES
		{
			PARENTCOLLAPSE GI_SETUP_DATA_IR_INTERPOLATION_SMOOTHING; 
			ANIM OFF;
		}		

		STATICTEXT { PARENTCOLLAPSE GI_SETUP_DATA_IR_INTERPOLATION_SMOOTHING; }
		
		// **************************************************************************************************
		// --- Color Correction ---
		LONG GI_SETUP_DATA_IR_COLOR_QUALITY
		{ 
			PARENTCOLLAPSE;
			ANIM OFF;
			CYCLE 
			{
				GI_SETUP_COLOR_CUSTOM;	
				GI_SETUP_COLOR_NONE;				
				GI_SETUP_COLOR_LOW;
				GI_SETUP_COLOR_MEDIUM;
				GI_SETUP_COLOR_HIGH;
				GI_SETUP_COLOR_VERY_HIGH;
			}
		}

		STATICTEXT { } 

		LONG GI_SETUP_DATA_IR_COLOR_PASSES
		{
			ANIM OFF;
			MIN 1; 
			MAX 4; 
			PARENTCOLLAPSE GI_SETUP_DATA_IR_COLOR_QUALITY; 
		}

		STATICTEXT { PARENTCOLLAPSE GI_SETUP_DATA_IR_COLOR_QUALITY; }

		REAL GI_SETUP_DATA_IR_COLOR_THRESHOLD
		{ 
			ANIM OFF;
			MIN 0.0; 
			MAX 100.0; 
			UNIT PERCENT;
			PARENTCOLLAPSE GI_SETUP_DATA_IR_COLOR_QUALITY; 
		}

		STATICTEXT { PARENTCOLLAPSE GI_SETUP_DATA_IR_COLOR_QUALITY; }

		REAL GI_SETUP_DATA_IR_COLOR_CUTOFF
		{ 
			ANIM OFF;
			MIN 0.0; 
			MAX 100.0; 
			UNIT PERCENT;
			PARENTCOLLAPSE GI_SETUP_DATA_IR_COLOR_QUALITY; 
		}

		STATICTEXT { PARENTCOLLAPSE GI_SETUP_DATA_IR_COLOR_QUALITY; } 

		REAL GI_SETUP_DATA_IR_COLOR_COOEF
		{ 
			ANIM OFF;
			MIN 0.0; 
			MAX 200.0; 
			UNIT PERCENT;
			PARENTCOLLAPSE GI_SETUP_DATA_IR_COLOR_QUALITY; 
		}

		STATICTEXT { PARENTCOLLAPSE GI_SETUP_DATA_IR_COLOR_QUALITY; }

		// **************************************************************************************************
		// --- Oversampling Properties ---
		LONG GI_SETUP_DATA_IR_OVERSAMPLING_METHOD
		{
			PARENTCOLLAPSE; 
			ANIM OFF;
			CYCLE
			{
				GI_SETUP_XSAMPLING_CUSTOM;
				GI_SETUP_XSAMPLING_NONE;
				GI_SETUP_XSAMPLING_MINIMAL;
				GI_SETUP_XSAMPLING_WEAK;
				GI_SETUP_XSAMPLING_MEDIUM;
				GI_SETUP_XSAMPLING_HEAVY;
				GI_SETUP_XSAMPLING_VERY_HEAVY;
			}
		}

		STATICTEXT { }
		
		LONG GI_SETUP_DATA_IR_OVERSAMPLING_RATIO
		{
			PARENTCOLLAPSE GI_SETUP_DATA_IR_OVERSAMPLING_METHOD; 
			ANIM OFF;
			MIN 1; 
			MAX 4096; 
		}

		STATICTEXT { PARENTCOLLAPSE GI_SETUP_DATA_IR_OVERSAMPLING_METHOD; }

		BOOL GI_SETUP_DATA_IR_OVERSAMPLING_ONLY
		{
			PARENTCOLLAPSE GI_SETUP_DATA_IR_OVERSAMPLING_METHOD; 
			ANIM OFF;
		}

		STATICTEXT { PARENTCOLLAPSE GI_SETUP_DATA_IR_OVERSAMPLING_METHOD; }

		// **************************************************************************************************
		// --- Distance Map ---
		BOOL GI_SETUP_DATA_IR_DISTANCE_MAP_ENABLED
		{
			ANIM OFF;
		}

		STATICTEXT {}

		
		// **************************************************************************************************
		// --- Visibility Check ---
		BOOL GI_SETUP_DATA_IR_VISIBILITY_CHECK_ENABLED
		{
			ANIM OFF;
		}

		STATICTEXT {}

		// **************************************************************************************************
		// --- Details Enhancement ---

		BOOL GI_SETUP_DATA_IR_DETAILS_ENABLE
		{ 
			PARENTCOLLAPSE; 
			ANIM OFF;
		}

		STATICTEXT { }

		BOOL GI_SETUP_DATA_IR_DETAILS_ADAPTIVE
		{
			PARENTCOLLAPSE GI_SETUP_DATA_IR_DETAILS_ENABLE; 
			ANIM OFF;
		}

		STATICTEXT { PARENTCOLLAPSE GI_SETUP_DATA_IR_DETAILS_ENABLE; }

		BOOL GI_SETUP_DATA_IR_DETAILS_ESTIMATE
		{
			PARENTCOLLAPSE GI_SETUP_DATA_IR_DETAILS_ENABLE; 
			ANIM OFF;
		}

		STATICTEXT { PARENTCOLLAPSE GI_SETUP_DATA_IR_DETAILS_ENABLE; }

		REAL GI_SETUP_DATA_IR_DETAILS_RADIUS
		{ 
			PARENTCOLLAPSE GI_SETUP_DATA_IR_DETAILS_ENABLE; 
			ANIM OFF;
			MIN 0.05; 
			MAX 0.25; 
			STEP 0.01; 
		}

		STATICTEXT { PARENTCOLLAPSE GI_SETUP_DATA_IR_DETAILS_ENABLE; }

		REAL GI_SETUP_DATA_IR_DETAILS_RATIO
		{ 
			PARENTCOLLAPSE GI_SETUP_DATA_IR_DETAILS_ENABLE; 
			ANIM OFF;
			MIN 25.0; 
			MAX 1000.0; 
			STEP 25.0;
			UNIT PERCENT;
		}
		
		STATICTEXT { PARENTCOLLAPSE GI_SETUP_DATA_IR_DETAILS_ENABLE; }			
		
		LONG GI_SETUP_DATA_IR_DETAILS_MODE
		{ 
			PARENTCOLLAPSE GI_SETUP_DATA_IR_DETAILS_ENABLE; 
			ANIM OFF;
			CYCLE 
			{ 
				GI_SETUP_DETAILS_COMBINE;
				GI_SETUP_DETAILS_DETAILS;
				GI_SETUP_DETAILS_GLOBAL;
			} 
		}
	}

	// **************************************************************************************************
	// --- Irradiance Cache Files ---
	GROUP GI_GROUP_IRRADIANCE_CACHES
	{
		GROUP
		{	
			COLUMNS 2;

			BUTTON GI_SETUP_DATA_CACHE_FLUSH 
			{ 
				FIT_H;
			}

			STATICTEXT GI_SETUP_DATA_CACHE_SIZE_RECORDS
			{
				SCALE_H;
			}

			//BUTTON GI_SETUP_DATA_CACHE_FLUSH_QANIMATION 
			//{ 
			//	FIT_H;
			//}
			
			//STATICTEXT { }

			BOOL GI_SETUP_DATA_CACHE_PREPASS
			{
				ANIM OFF;
			}

			STATICTEXT { }

			BOOL GI_SETUP_DATA_CACHE_LOCK
			{
				ANIM OFF;
			}

			STATICTEXT { }
		
			BOOL GI_SETUP_DATA_CACHE_AUTOLOAD
			{
				ANIM OFF;
			}

			STATICTEXT { }
				
			BOOL GI_SETUP_DATA_CACHE_AUTOSAVE
			{
				ANIM OFF;
			}

			STATICTEXT { }
		}

		SEPARATOR 
		{ 
			LINE;
		}

		GROUP
		{
			BOOL GI_SETUP_DATA_CACHE_CUSTOM_PATH_ENABLED
			{
				ANIM OFF;
			}

			FILENAME GI_SETUP_DATA_CACHE_CUSTOM_PATH
			{
				ANIM OFF;
				SAVE;
			}
		}
	}

	// **************************************************************************************************
	// --- Extra
	GROUP GI_SETUP_DATA_ENHANCED
	{
		LONG GI_SETUP_DATA_EXTRA_DEBUG_LEVEL
		{
			ANIM OFF;
			CYCLE 
			{ 
				GI_SETUP_DEBUG_NONE;
				GI_SETUP_DEBUG_MINIMAL;
				GI_SETUP_DEBUG_COMPLETE;
			} 

		}

		REAL GI_SETUP_DATA_EXTRA_NON_DIFFUSE_CUTOFF
		{ 
			ANIM OFF;
			MIN 50.0; 
			MAX 100.0; 
			UNIT PERCENT;
		}

		BOOL GI_SETUP_DATA_EXTRA_REFRACTIVECAUSTICS 
		{ 
			ANIM OFF; 
		}

		BOOL GI_SETUP_DATA_EXTRA_REFLECTIVECAUSTICS 
		{ 
			ANIM OFF; 
		}

		BOOL GI_SETUP_DATA_EXTRA_DIFFUSE_ONLY
		{
			ANIM OFF;
		}

		BOOL GI_SETUP_DATA_EXTRA_HIDE_PREPASS
		{
			ANIM OFF;
		}
	}
}
